<?php
include '../kariyersoft/config.php'; // Veritabanı bağlantısı
include 'header.php'; 

if (isset($_POST['upload'])) {
    // CSV dosyasını yükleyin
    if ($_FILES['csv_file']['error'] == 0) {
        $filename = $_FILES['csv_file']['tmp_name'];
        $file = fopen($filename, 'r');
        
        // CSV dosyasındaki ilk satırı başlık olarak kabul edelim
        fgetcsv($file);

        // Dosyadaki her satırı okuyarak veritabanına ekleyelim
        while (($data = fgetcsv($file, 1000, ",")) !== FALSE) {
            $urun_ad = $data[0];
            $urun_stok = $data[1];
            $urun_fiyat = $data[2];
            $urun_durum = $data[3];
            $kategori_id = $data[4];

            // Veritabanına veri ekleme
            $stmt = $db->prepare("INSERT INTO urun (urun_ad, urun_stok, urun_fiyat, urun_durum, kategori_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$urun_ad, $urun_stok, $urun_fiyat, $urun_durum, $kategori_id]);
        }

        fclose($file);
        $message = '<p style="color: green; font-weight: bold;">Veriler başarıyla yüklendi.</p>';
    } else {
        $message = '<p style="color: red; font-weight: bold;">Dosya yükleme hatası oluştu.</p>';
    }
}
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#"><em class="fa fa-home"></em></a></li>
            <li class="active">CSV Dosya Yükleme</li>
        </ol>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">CSV Dosya Yükleme</h1>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    CSV Dosyası Yükleme
                </div>
                <div class="panel-body">
                    <?php if (isset($message)) echo $message; ?>

                    <form method="post" enctype="multipart/form-data" class="text-center">
                        <div class="form-group">
                            <label for="csv_file">CSV Dosyası Yükleyin:</label>
                            <input type="file" name="csv_file" id="csv_file" class="form-control-file" required>
                        </div>
                        <button type="submit" name="upload" class="btn btn-success btn-lg btn-block mt-3">Yükle</button>
                    </form>
                </div>
            </div>
        </div><!--/.col-->
    </div><!--/.row-->
</div> <!--/.main-->

<?php include 'footer.php'; ?>
    