<?php
include 'header.php';



// Toplam kategori sayısını çekmek için sorgu
$kategori_sayisi_sorgu = $db->query("SELECT COUNT(*) AS kategori_sayisi FROM kategori");
$kategori_sayisi = $kategori_sayisi_sorgu->fetch(PDO::FETCH_ASSOC)['kategori_sayisi'];

// Toplam ürün sayısını çekmek için sorgu
$urun_sayisi_sorgu = $db->query("SELECT COUNT(*) AS urun_sayisi FROM urun");
$urun_sayisi = $urun_sayisi_sorgu->fetch(PDO::FETCH_ASSOC)['urun_sayisi'];

// Toplam personel sayısını çekmek için sorgu
$personel_sayisi_sorgu = $db->query("SELECT COUNT(*) AS personel_sayisi FROM personel");
$personel_sayisi = $personel_sayisi_sorgu->fetch(PDO::FETCH_ASSOC)['personel_sayisi'];

// Toplam aktif firma sayısını çekmek için sorgu
$firma_sayisi_sorgu = $db->query("SELECT COUNT(*) AS firma_sayisi FROM firma");
$firma_sayisi = $firma_sayisi_sorgu->fetch(PDO::FETCH_ASSOC)['firma_sayisi'];

// Kullanılan malzeme sayısını çekmek için sorgu
$malzeme_sayisi_sorgu = $db->query("SELECT SUM(miktar) AS malzeme_sayisi FROM urun_personel");
$malzeme_sayisi = $malzeme_sayisi_sorgu->fetch(PDO::FETCH_ASSOC)['malzeme_sayisi'] ?? 11; // NULL kontrolü
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    
    <div class="row panel-container">
        <div class="col-xs-12 col-md-4 no-padding">
            <div class="panel panel-primary">
                <div class="panel-heading">Toplam Ürün Adedi</div>
                <div class="panel-body">
                    <div class="large"><?php echo $urun_sayisi; ?></div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-4 no-padding">
            <div class="panel panel-success">
                <div class="panel-heading">Kategori Sayısı</div>
                <div class="panel-body">
                    <div class="large"><?php echo $kategori_sayisi; ?></div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-4 no-padding">
            <div class="panel panel-info">
                <div class="panel-heading">Toplam Personel Sayısı</div>
                <div class="panel-body">
                    <div class="large"><?php echo $personel_sayisi; ?></div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-4 no-padding">
            <div class="panel panel-warning">
                <div class="panel-heading">Toplam Firma Sayısı</div>
                <div class="panel-body">
                    <div class="large"><?php echo $firma_sayisi; ?></div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-4 no-padding">
            <div class="panel panel-danger">
                <div class="panel-heading">Kullanılan Malzeme Sayısı</div>
                <div class="panel-body">
                    <div class="large"><?php echo $malzeme_sayisi; ?></div>
                </div>
            </div>
        </div>
    </div><!--/.row-->

 <!--/   <div class="row">
        <div class="col-xs-12 col-md-6">
            <div class="panel panel-default">
                <div class="panel-body easypiechart-panel">
                    <h4>Toplam Ürün Adedi</h4>
                    <div class="easypiechart" id="easypiechart-blue" data-percent="<?php echo ($urun_sayisi > 0) ? $urun_sayisi : 0; ?>">
                        <span class="percent"><?php echo $urun_sayisi; ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-6">
            <div class="panel panel-default">
                <div class="panel-body easypiechart-panel">
                    <h4>Kategori Sayısı</h4>
                    <div class="easypiechart" id="easypiechart-teal" data-percent="<?php echo ($kategori_sayisi > 0) ? $kategori_sayisi : 0; ?>">
                        <span class="percent"><?php echo $kategori_sayisi; ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-6">
            <div class="panel panel-default">
                <div class="panel-body easypiechart-panel">
                    <h4>Toplam Personel Sayısı</h4>
                    <div class="easypiechart" id="easypiechart-green" data-percent="<?php echo ($personel_sayisi > 0) ? $personel_sayisi : 0; ?>">
                        <span class="percent"><?php echo $personel_sayisi; ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-md-6">
            <div class="panel panel-default">
                <div class="panel-body easypiechart-panel">
                    <h4>Ekli Firmalar</h4>
                    <div class="easypiechart" id="easypiechart-red" data-percent="<?php echo ($firma_sayisi > 0) ? $firma_sayisi : 0; ?>">
                        <span class="percent"><?php echo $firma_sayisi; ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>.row-->

</div><!--/.main-->

<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/chart.min.js"></script>
<script src="js/chart-data.js"></script>
<script src="js/easypiechart.js"></script>
<script src="js/easypiechart-data.js"></script>
<script src="js/bootstrap-datepicker.js"></script>
<script src="js/custom.js"></script>
<script>
    window.onload = function () {
        var chart1 = document.getElementById("line-chart").getContext("2d");
        window.myLine = new Chart(chart1).Line(lineChartData, {
            responsive: true,
            scaleLineColor: "rgba(0,0,0,.2)",
            scaleGridLineColor: "rgba(0,0,0,.05)",
            scaleFontColor: "#c5c7cc"
        });
    };
</script>

<style>
    body {
        overflow-x: auto; /* Yatay kaydırma çubuğu */
        font-family: Arial, sans-serif; /* Yazı tipi */
    }
    .main {
        display: flex;
        flex-direction: column; /* Dikey yerleşim */
        align-items: center; /* Ortala */
        padding: 20px; /* İçerik için boşluk */
    }
    .panel-container {
        display: flex;
        flex-wrap: wrap; /* Taşma durumunda yeni satıra geç */
        justify-content: center; /* Elemanları ortala */
        width: 100%; /* Tam genişlik */
    }
    .panel {
        border-radius: 10px; /* Köşeleri yuvarlat */
        margin: 10px; /* Kenar boşluğu */
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); /* Gölgelendirme efekti */
    }
    .panel-heading {
        background-color: #5bc0de; /* Başlık arka plan rengi */
        color: white; /* Başlık yazı rengi */
        font-size: 20px; /* Başlık boyutu */
        text-align: center; /* Ortala */
        padding: 15px; /* İçerik için boşluk */
    }
    .panel-body {
        background-color: #f5f5f5; /* Gövde arka plan rengi */
        text-align: center; /* İçerik ortalaması */
        padding: 30px; /* İçerik için boşluk */
    }
    .large {
        font-size: 30px; /* Sayı boyutu */
        font-weight: bold; /* Sayı kalınlığı */
    }
    .easypiechart {
        width: 100px; /* EasyPieChart genişliği */
        height: 100px; /* EasyPieChart yüksekliği */
        margin: 0 auto; /* Ortalamak için */
    }
    .percent {
        display: block; /* Yüzde bloğu */
        font-size: 20px; /* Yüzde boyutu */
        color: #333; /* Yüzde rengi */
    }
    .color-blue {
        color: #5bc0de; /* Mavi renk */
    }
    .color-teal {
        color: #20B2AA; /* Teal rengi */
    }
    .color-green {
        color: #5cb85c; /* Yeşil renk */
    }
    .color-orange {
        color: #f0ad4e; /* Turuncu renk */
    }
    .color-red {
        color: #d9534f; /* Kırmızı renk */
    }
</style>

<?php
include 'footer.php';
?>
