<?php 
include 'header.php'; 

$kategorisor = $db->prepare("SELECT * FROM kategori ORDER BY kategori_sira ASC");
$kategorisor->execute();
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#">
                <em class="fa fa-home"></em>
            </a></li>
            <li class="active">Kategori Ayarları</li>
        </ol>
    </div><!--/.row-->
    
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Kategori Ayarları</h1>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-md-15">
            <div class="panel panel-default articles">
                <div class="panel-heading">
                    Kategori Listesi
                    <?php
                    if (isset($_GET['durum'])) {
                        $durum = $_GET['durum'];
                        if ($durum == "ok") {
                            echo '<b style="color:green;">İşlem Başarılı</b>';
                        } elseif ($durum == "no") {
                            echo '<b style="color:red;">İşlem Başarısız</b>';
                        } 
                    } 
                    ?>
                </div>
                <div class="table-responsive m-b-60">
                    <table id="datatable-responsive" class="table table-bordered table-hover" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>Kategori ID No</th>
                                <th>Kategori İsmi</th>
                                <th>Kategori Sırası</th>
                                <th>Kategori Durum</th>
                                <th>Kategori Düzenle</th>
                                <th>Kategori Sil</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $say = 0;
                            while ($kategoricek = $kategorisor->fetch(PDO::FETCH_ASSOC)) { 
                                $say++; 
                            ?>
                            <tr>
                                <td><?php echo $say ?></td>
                                <td><?php echo $kategoricek['kategori_ad'] ?></td>
                                <td><?php echo $kategoricek['kategori_sira'] ?></td>
                                <td>
                                    <?php 
                                    if ($kategoricek['kategori_durum'] == 1) {
                                        echo '<button class="btn btn-success btn-xs"> Aktif </button>'; 
                                    } else {
                                        echo '<button class="btn btn-danger btn-xs"> Pasif </button>'; 
                                    }
                                    ?>
                                </td>
                                <td>
                                    <a href="kategori-duzenle.php?kategori_id=<?php echo $kategoricek['kategori_id']; ?>" class="btn btn-primary btn-xs">Düzenle</a>
                                </td>
                                <td>
                                    <a href="../kariyersoft/control.php?kategori_id=<?php echo $kategoricek['kategori_id']; ?>&kategoridelete=ok" class="btn btn-danger btn-xs">Sil</a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <div class="panel-footer">
                    <a href="kategori-ekle.php" class="btn btn-warning btn-md">Kategori Ekle</a>
                </div>
            </div>
        </div><!--/.col-->
    </div><!--/.row-->
</div><!--/.main-->

<?php include 'footer.php'; ?>

<style>
    /* Sayfa başlık stil ayarları */
    .page-header {
        font-size: 24px;
        margin-bottom: 20px;
        font-weight: bold;
    }

    /* Panel ayarları */
    .panel {
        margin-bottom: 20px;
    }

    .panel-heading {
        background-color: #f8f9fa;
        font-size: 18px;
        font-weight: bold;
        border-bottom: 1px solid #e5e5e5;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .table th, .table td {
        padding: 15px;
        vertical-align: middle;
        border: 1px solid #dee2e6;
    }

    .table th {
        background-color: #f2f2f2;
        text-align: center;
    }

    .table td {
        text-align: center;
    }

    /* Buton ayarları */
    .btn {
        margin: 0 5px;
    }
</style>

</body>
</html>
