<?php
include 'header.php';

// Malzeme sıfırlama işlemi
if (isset($_POST['sil'])) {
    $silSorgu = $db->prepare("DELETE FROM urun_personel");
    if ($silSorgu->execute()) {
        echo "<script>alert('Kullanılan malzemeler başarıyla silindi.'); window.location.href = 'malzeme.php';</script>";
    } else {
        echo "<script>alert('Silme işlemi sırasında bir hata oluştu.');</script>";
    }
}

// Ürünü silme işlemi
if (isset($_POST['urun_sil'])) {
    $urunId = $_POST['urun_id'];
    $urunSilSorgu = $db->prepare("DELETE FROM urun_personel WHERE id = :urun_id");
    $urunSilSorgu->bindValue(':urun_id', $urunId, PDO::PARAM_INT);
    if ($urunSilSorgu->execute()) {
        echo "<script>alert('Ürün başarıyla silindi.'); window.location.href = 'malzeme.php';</script>";
    } else {
        echo "<script>alert('Silme işlemi sırasında bir hata oluştu.');</script>";
    }
}

// Güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['urun_id'])) {
    $urunId = $_POST['urun_id'];
    $miktar = $_POST['miktar'];
    $kullanim_yeri = $_POST['kullanim_yeri'];
    $amac = $_POST['amac'];
    $personelId = $_POST['personel_id'];
    $yeniUrunId = $_POST['yeni_urun_id']; // Yeni ürün ID'si

    // Önce mevcut miktarı çek
    $mevcutMiktarSorgu = $db->prepare("SELECT miktar, urun_id FROM urun_personel WHERE id = :urun_id");
    $mevcutMiktarSorgu->bindValue(':urun_id', $urunId, PDO::PARAM_INT);
    $mevcutMiktarSorgu->execute();
    $mevcutMiktarVeri = $mevcutMiktarSorgu->fetch(PDO::FETCH_ASSOC);
    
    if ($mevcutMiktarVeri) {
        $mevcutMiktar = $mevcutMiktarVeri['miktar'];
        $urun_id = $mevcutMiktarVeri['urun_id'];

        // Güncellemeyi yap
        $guncelleSorgu = $db->prepare("UPDATE urun_personel SET miktar = :miktar, kullanim_yeri = :kullanim_yeri, amac = :amac, personel_id = :personel_id, urun_id = :yeni_urun_id WHERE id = :urun_id");
        $guncelleSorgu->bindValue(':miktar', $miktar, PDO::PARAM_INT);
        $guncelleSorgu->bindValue(':kullanim_yeri', $kullanim_yeri, PDO::PARAM_STR);
        $guncelleSorgu->bindValue(':amac', $amac, PDO::PARAM_STR);
        $guncelleSorgu->bindValue(':personel_id', $personelId, PDO::PARAM_INT);
        $guncelleSorgu->bindValue(':yeni_urun_id', $yeniUrunId, PDO::PARAM_INT);
        $guncelleSorgu->bindValue(':urun_id', $urunId, PDO::PARAM_INT);

        if ($guncelleSorgu->execute()) {
            // Stok güncellemesi
            $stokFarki = $miktar - $mevcutMiktar; // Miktardaki değişimi hesapla

            // Stok güncellemeyi kontrol et
            $stokGuncellemeSorgu = $db->prepare("UPDATE urun SET urun_stok = urun_stok - :stok_farki WHERE urun_id = :urun_id");
            $stokGuncellemeSorgu->bindValue(':stok_farki', $stokFarki, PDO::PARAM_INT);
            $stokGuncellemeSorgu->bindValue(':urun_id', $urun_id, PDO::PARAM_INT);
            $stokGuncellemeSorgu->execute();

            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
}

// Sayfalama ayarları
$sayfaBoyutu = 20; 
$mevcutSayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$offset = ($mevcutSayfa - 1) * $sayfaBoyutu;

// Toplam ürün sayısını bulma
$toplamUrunSorgu = $db->prepare("SELECT COUNT(*) as toplam FROM urun_personel");
$toplamUrunSorgu->execute();
$toplamUrunSayisi = $toplamUrunSorgu->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplamSayfa = ceil($toplamUrunSayisi / $sayfaBoyutu);

// Personel bilgilerini ve Kullanılan ürünleri çekme işlemi
$personelUrunSorgu = $db->prepare("
    SELECT urun_personel.*, urun.urun_ad, personel.personel_ad
    FROM urun_personel
    LEFT JOIN urun ON urun_personel.urun_id = urun.urun_id
    LEFT JOIN personel ON urun_personel.personel_id = personel.personel_id
    ORDER BY urun_personel.id DESC
    LIMIT :offset, :sayfaBoyutu
");
$personelUrunSorgu->bindValue(':offset', $offset, PDO::PARAM_INT);
$personelUrunSorgu->bindValue(':sayfaBoyutu', $sayfaBoyutu, PDO::PARAM_INT);
$personelUrunSorgu->execute();

// Ürünleri çekme sorgusu
$urunSorgu = $db->prepare("SELECT * FROM urun");
$urunSorgu->execute();
$urunler = $urunSorgu->fetchAll(PDO::FETCH_ASSOC);

// Personel listesini al
$personelListesiSorgu = $db->prepare("SELECT * FROM personel");
$personelListesiSorgu->execute();
$personeller = $personelListesiSorgu->fetchAll(PDO::FETCH_ASSOC);
?>
<!-- Bootstrap ve Ek Stil Sayfası -->
<style>
    /* Ana başlık rengi */
    .page-header {
        color: #4B6CB7;
        border-bottom: 2px solid #4B6CB7;
    }
    
    /* Panel başlığı rengi ve yazı tipi */
    .panel-heading h4 {
        font-weight: bold;
        color: #6C757D;
    }
    
    /* Tablo başlığı ve satır arka plan renkleri */
    .table thead th {
        background-color: #4B6CB7;
        color: #fff;
        text-align: center;
    }
    
    .table tbody tr:nth-child(even) {
        background-color: #f2f2f2;
    }
    
    /* Düzenle ve Sil düğmelerine renk ve stil ekleme */
    .btn-warning {
        background-color: #FFAA00;
        border: none;
        color: white;
    }
    
    .btn-danger {
        background-color: #FF4D4D;
        border: none;
        color: white;
    }
    
    /* Sayfalama butonları */
    .pagination li.active a {
        background-color: #4B6CB7;
        border-color: #4B6CB7;
        color: white;
    }
    
    /* Modal başlık rengi ve kapatma butonu */
    .modal-header {
        background-color: #4B6CB7;
        color: white;
    }
    
    /* Modal içinde yer alan form elemanlarının daha belirgin görünmesi */
    .modal-body .form-group label {
        color: #4B6CB7;
        font-weight: bold;
    }

    /* "Malzeme Sıfırla" butonunun rengi */
    .btn-danger {
        background-color: #E74C3C;
        border: none;
    }
</style>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#"><em class="fa fa-home"></em></a></li>
            <li class="active">Kullanılan Ürünler</li>
        </ol>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Kullanılan Ürünler</h1>
            <form method="POST" style="display: inline-block; float: right;">
                <button type="submit" name="sil" class="btn btn-danger">Malzeme Sıfırla</button>
            </form>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4 style="display: inline-block;">Kullanılan Ürün Listesi</h4>
                </div>
                
                <div class="table-responsive">
                    <table id="datatable-responsive" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Personel Adı</th>
                                <th>Ürün Adı</th>
                                <th>Miktar</th>
                                <th>Kullanım Yeri</th>
                                <th>Amaç</th>
                                <th>Azaltılan Tarih</th>
                                <th>Düzenle</th>
                                <th>Sil</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            while ($veri = $personelUrunSorgu->fetch(PDO::FETCH_ASSOC)) {
                                ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($veri['personel_ad']); ?></td>
                                    <td><?php echo htmlspecialchars($veri['urun_ad']); ?></td>
                                    <td><?php echo htmlspecialchars($veri['miktar']); ?></td>
                                    <td><?php echo htmlspecialchars($veri['kullanim_yeri']); ?></td>
                                    <td><?php echo htmlspecialchars($veri['amac']); ?></td>
                                    <td><?php echo $veri['azaltilan_tarih'] ? htmlspecialchars(date('Y-m-d H:i:s', strtotime($veri['azaltilan_tarih']))) : 'N/A'; ?></td>
                                    
                                    <td>
                                        <button class="btn btn-warning" data-toggle="modal" data-target="#duzenleModal<?php echo $veri['id']; ?>">Düzenle</button>
                                    </td>
                                    <td>
                                        <form method="POST" style="display: inline;">
                                            <input type="hidden" name="urun_id" value="<?php echo $veri['id']; ?>">
                                            <button type="submit" name="urun_sil" class="btn btn-danger">Sil</button>
                                        </form>
                                    </td>
                                </tr>

                                <!-- Düzenleme Modalı -->
                                <div class="modal fade" id="duzenleModal<?php echo $veri['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="duzenleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="duzenleModalLabel">Düzenle</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form method="POST">
                                                    <input type="hidden" name="urun_id" value="<?php echo $veri['id']; ?>">
                                                    <div class="form-group">
                                                        <label for="miktar">Miktar:</label>
                                                        <input type="number" class="form-control" name="miktar" value="<?php echo htmlspecialchars($veri['miktar']); ?>" required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="kullanim_yeri">Kullanım Yeri:</label>
                                                        <input type="text" class="form-control" name="kullanim_yeri" value="<?php echo htmlspecialchars($veri['kullanim_yeri']); ?>" required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="amac">Amaç:</label>
                                                        <input type="text" class="form-control" name="amac" value="<?php echo htmlspecialchars($veri['amac']); ?>" required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="personel_id">Personel:</label>
                                                        <select name="personel_id" class="form-control" required>
                                                            <?php foreach ($personeller as $personel): ?>
                                                                <option value="<?php echo $personel['personel_id']; ?>" <?php echo $personel['personel_id'] == $veri['personel_id'] ? 'selected' : ''; ?>>
                                                                    <?php echo htmlspecialchars($personel['personel_ad']); ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="yeni_urun_id">Yeni Ürün Seç:</label>
                                                        <select name="yeni_urun_id" class="form-control" required>
                                                            <?php foreach ($urunler as $urun): ?>
                                                                <option value="<?php echo $urun['urun_id']; ?>" <?php echo $urun['urun_id'] == $veri['urun_id'] ? 'selected' : ''; ?>>
                                                                    <?php echo htmlspecialchars($urun['urun_ad']); ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <div class="panel-footer">
                    <ul class="pagination">
                        <?php for ($i = 1; $i <= $toplamSayfa; $i++): ?>
                            <li class="<?php echo $i == $mevcutSayfa ? 'active' : ''; ?>">
                                <a href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div><!--/.row-->
</div><!--/.main-->


<?php include 'footer.php'; ?>
