<?php
include 'header.php';
require 'vendor/autoload.php'; // mPDF kütüphanesini ekleyin

use Mpdf\Mpdf;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Seçilen ürünleri ve adet bilgilerini al
    $secilen_urunler = $_POST['secilen_urunler'];
    $adetler = $_POST['adet'];

    // Dosya adı ve yolunu belirle
    $dosyaAdi = 'Siparis_Talep_Formu.pdf';

    // Veritabanından gerekli bilgileri al
    $veriler = array();
    $toplamFiyatlar = 0;

    foreach ($secilen_urunler as $urun_id) {
        // Ürün sorgusu
        $urun_sorgu = $db->prepare("SELECT urun_id, urun_ad, urun_fiyat, kategori.kategori_ad 
                                    FROM urun 
                                    INNER JOIN kategori ON urun.kategori_id = kategori.kategori_id 
                                    WHERE urun_id = ?");
        $urun_sorgu->execute([$urun_id]);
        $urun = $urun_sorgu->fetch(PDO::FETCH_ASSOC);

        // Eğer ürün veritabanında yoksa, hatayla karşılaşmamak için kontrol edelim
        if (!$urun) {
            continue; // Bu ürünü atla, çünkü veritabanında yok
        }

        // Ürün adet ve fiyat hesaplaması
        $urun_adet = $adetler[$urun_id];
        $birimFiyat = $urun['urun_fiyat'];
        $toplamFiyat = $birimFiyat * $urun_adet;
        $toplamFiyatlar += $toplamFiyat;

        $veriler[] = array(
            'Ürün ID' => $urun['urun_id'],
            'Ürün Adı' => $urun['urun_ad'],
            'Birim Fiyat' => $birimFiyat,
            'Kategori' => $urun['kategori_ad'],
            'Adet' => $urun_adet,
            'Toplam Fiyat' => $toplamFiyat
        );
    }

    // mPDF ile PDF oluşturma
    $mpdf = new Mpdf();

    // PDF içeriğini oluştur
    $html = '<h1>Sipariş Talep Formu</h1>';
    $html .= '<table border="1" cellspacing="0" cellpadding="10">';
    $html .= '<tr>
                <th>Ürün ID</th>
                <th>Ürün Adı</th>
                <th>Birim Fiyat</th>
                <th>Kategori</th>
                <th>Adet</th>
                <th>Toplam Fiyat</th>
              </tr>';

    foreach ($veriler as $urun) {
        $html .= '<tr>
                    <td>' . $urun['Ürün ID'] . '</td>
                    <td>' . $urun['Ürün Adı'] . '</td>
                    <td>' . $urun['Birim Fiyat'] . ' TL</td>
                    <td>' . $urun['Kategori'] . '</td>
                    <td>' . $urun['Adet'] . '</td>
                    <td>' . $urun['Toplam Fiyat'] . ' TL</td>
                  </tr>';
    }

    // Toplam fiyat bilgisini ekle
    $html .= '<tr>
                <td colspan="5" style="text-align:right;"><strong>Toplam Fiyat</strong></td>
                <td><strong>' . $toplamFiyatlar . ' TL</strong></td>
              </tr>';
    $html .= '</table>';

    $mpdf->WriteHTML($html);

    // PDF dosyasını kaydet ve indirme başlat
    $mpdf->Output($dosyaAdi, 'D'); // 'D' for download
    exit;
}

include 'footer.php'; 
?>
